import EditorPage from '@/editor/EditorPage'
import FinalInformationForm from '@/editor/FinalInformationForm'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const FinalInformationPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.FINAL_INFORMATION}
      prevPath='/editor/create/other'
      nextPath='/editor/create/conclusion'
      nextDisabled={!access?.finalInformationFilled}
      pageVisible={access?.specificationsFilled}
    >
      <FinalInformationForm />
    </EditorPage>
  )
}

export default memo(FinalInformationPage)
