import EditorPage from '@/editor/EditorPage'
import ExerciseInformationForm from '@/editor/ExerciseInformationForm'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const ExerciseInformationPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.EXERCISE_INFORMATION}
      prevPath='/editor/create/introduction'
      nextPath='/editor/create/learning-objectives'
      pageVisible={access?.introductionFilled}
      nextDisabled={!access?.exerciseInformationFilled}
    >
      <ExerciseInformationForm />
    </EditorPage>
  )
}

export default memo(ExerciseInformationPage)
