import ConclusionForm from '@/editor/ConclusionForm'
import EditorPage from '@/editor/EditorPage'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const ConclusionPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.CONCLUSION}
      prevPath='/editor/create/final-information'
      nextPath='/editor/create/save'
      nextDisabled={!access?.conclusionFilled}
      pageVisible={access?.finalInformationFilled}
    >
      <ConclusionForm />
    </EditorPage>
  )
}

export default memo(ConclusionPage)
