import EditorPage from '@/editor/EditorPage'
import LearningActivitiesOverview from '@/editor/LearningActivitiesOverview'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const ActivitiesSpecificationPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.ACTIVITY_SPECIFICATION_OVERVIEW}
      prevPath='/editor/create/injects'
      nextPath='/editor/create/inject-specification'
      pageVisible={access?.injectsFilled}
    >
      <LearningActivitiesOverview />
    </EditorPage>
  )
}

export default memo(ActivitiesSpecificationPage)
