import { useSetPageTitle, useStaffBoundary } from '@/utils'
import CenteredSpinner from '@inject/shared/components/CenteredSpinner'
import { Suspense } from 'react'
import { Outlet } from 'react-router-dom'

const Layout = () => {
  useStaffBoundary()
  useSetPageTitle('Analyst')

  return (
    <Suspense fallback={<CenteredSpinner />}>
      <Outlet />
    </Suspense>
  )
}

export default Layout
