import type { Section } from '@/components/Sidebar'
import Sidebar from '@/components/Sidebar'
import { useNavigate } from '@/router'
import UserCreator from '@/users/UserCreator'
import Active from '@/users/UserTable/Filters/Active'
import Columns from '@/users/UserTable/Filters/Columns'
import Tags from '@/users/UserTable/Filters/Tags'
import UserGroups from '@/users/UserTable/Filters/UserGroups'
import useUserTable from '@/users/UserTable/useUserTable'
import type { UserProperty } from '@/users/UserTable/utils'
import { AUTH_GROUPS, USER_PROPERTIES } from '@/users/UserTable/utils'
import UsersUploader from '@/users/UsersUploader'
import { useSetPageTitle, useStaffBoundary } from '@/utils'
import { Button, ButtonGroup, InputGroup } from '@blueprintjs/core'
import { css } from '@emotion/css'
import Reloader from '@inject/graphql/components/Reloader'
import { ReloadTable } from '@inject/graphql/mutations.client'
import { useState } from 'react'
import { useClient } from 'urql'

const page = css`
  display: flex;
  height: 100%;
`

const body = css`
  padding: 1rem;
  display: flex;
  flex-direction: column;
  gap: 1rem;
`

const Page = () => {
  useSetPageTitle('User management')
  useStaffBoundary()
  const client = useClient()

  const nav = useNavigate()

  // TODO: add reset for filters and columns
  const [searchString, setSearchString] = useState('')
  const [groups, setGroups] = useState(AUTH_GROUPS)
  const [active, setActive] = useState<{ active: boolean; inactive: boolean }>({
    active: true,
    inactive: true,
  })
  const [tags, setTags] = useState<string[]>([])
  const [properties, setProperties] = useState<UserProperty[]>(USER_PROPERTIES)
  const { table, deleteButton } = useUserTable({
    onClick: (userId: string) => nav('/users/:userId', { params: { userId } }),
    groups,
    active,
    tags,
    searchString,
    properties,
  })

  const sections: Section[] = [
    {
      id: 'options',
      name: 'Options',
      node: (
        <>
          <UserCreator />
          <UsersUploader />
          <Columns selected={properties} setSelected={setProperties} />
          <Reloader
            minimal
            fill
            alignText='left'
            queries={() => {
              client.mutation(ReloadTable, {}).toPromise()
            }}
            withLabel
            text='Reload list'
          />
          {/* TODO: this is hack-around until DeleteButton gets fixed in #545 */}
          <ButtonGroup fill alignText='left' minimal>
            {deleteButton}
          </ButtonGroup>
        </>
      ),
    },
    {
      id: 'filters',
      name: 'Filters',
      node: (
        <>
          <UserGroups selected={groups} setSelected={setGroups} />
          <Active selected={active} setSelected={setActive} />
          <Tags selected={tags} setSelected={setTags} />
        </>
      ),
    },
  ]

  return (
    <div className={page}>
      <div className={body}>
        <InputGroup
          placeholder='Search...'
          leftIcon='search'
          value={searchString}
          onChange={event => setSearchString(event.target.value)}
          rightElement={
            <Button
              icon='cross'
              minimal
              onClick={() => setSearchString('')}
              disabled={!searchString}
            />
          }
        />
        {table}
      </div>
      <Sidebar position='right' sections={sections} />
    </div>
  )
}

export default Page
