import ColorMode from '@/clientsettings/components/ColorMode'
import Connection from '@/clientsettings/components/Connection'
import Experimental from '@/clientsettings/components/Experimental'
import GraphiQL from '@/clientsettings/components/GraphiQL'
import NotificationSystem from '@/clientsettings/components/NotificactionSystem'
import NotificationLimit from '@/clientsettings/components/NotificationLimit'
import Voyager from '@/clientsettings/components/Voyager'
import { useSetPageTitle } from '@/utils'
import { Section, SectionCard } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useAuthIdentity } from '@inject/graphql/auth'
import Container from '@inject/shared/components/Container'

const wrapper = css`
  padding: 1rem 0;
  display: flex;
  flex-direction: column;
  gap: 1rem;
`

const sectionBody = css`
  display: flex;
  flex-direction: column;
  gap: 1rem;
`

const Settings = () => {
  useSetPageTitle('Settings')
  const { isSuperuser } = useAuthIdentity()

  return (
    <Container className={wrapper}>
      <Section title='Settings' icon='cog'>
        <SectionCard padded className={sectionBody}>
          <ColorMode />
          <NotificationLimit />
          <Connection />
          {isSuperuser && <GraphiQL />}
          {isSuperuser && <Voyager />}
          <Experimental />
          <NotificationSystem />
        </SectionCard>
      </Section>
    </Container>
  )
}

export default Settings
