import ExerciseList from '@/components/ExerciseList'
import { useNavigate } from '@/router'
import { useSetPageTitle } from '@/utils'
import {
  Button,
  ButtonGroup,
  Dialog,
  DialogBody,
  DialogFooter,
} from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useAuthIdentity } from '@inject/graphql/auth'
import type { Exercise } from '@inject/graphql/fragment-types'
import Container from '@inject/shared/components/Container'
import InjectLogo from '@inject/shared/svg/inject-logo--vertical-black.svg?react'
import { useState } from 'react'

const index = css`
  min-height: 100%;
  height: fit-content;
  display: flex;
  flex-direction: column;
  justify-content: center;
`

const logo = css`
  height: 12rem;
  width: fit-content;

  @media (max-width: 40rem) {
    height: 8rem;
  }
`

const intro = css`
  display: flex;
  justify-content: center;
  align-items: center;
`

const Index = () => {
  useSetPageTitle('')
  const nav = useNavigate()
  const { isStaff } = useAuthIdentity()
  const [selectedExercise, setSelectedExercise] = useState<Exercise | null>(
    null
  )

  return (
    <Container className={index}>
      <div className={intro}>
        <InjectLogo className={logo} />
      </div>
      <h3>Select your exercise</h3>
      <ExerciseList
        type='selecting'
        details={exercise => ({
          onSelect: () => {
            if (isStaff) {
              setSelectedExercise(exercise)
            } else {
              nav('/trainee/:exerciseId', {
                params: {
                  exerciseId: exercise.id,
                },
              })
            }
          },
        })}
      />
      <Dialog isOpen={!!selectedExercise}>
        <DialogBody>
          <ButtonGroup
            large
            fill
            className={css`
              .bp5-button {
                flex-direction: column;
                aspect-ratio: 1;
              }
              .bp5-button .bp5-icon {
                margin-right: 0;
                height: 3rem;
              }
              svg {
                height: 2rem;
                width: 2rem;
              }
            `}
            alignText='center'
          >
            <Button
              icon='person'
              onClick={() => {
                nav('/trainee/:exerciseId', {
                  params: {
                    exerciseId: selectedExercise?.id as string,
                  },
                })
              }}
            >
              Trainee
            </Button>
            <Button
              icon='intelligence'
              onClick={() => {
                nav('/instructor/:exerciseId/select', {
                  params: {
                    exerciseId: selectedExercise?.id as string,
                  },
                })
              }}
            >
              Instructor
            </Button>
            <Button
              icon='series-search'
              onClick={() => {
                nav('/analyst/:exerciseId', {
                  params: {
                    exerciseId: selectedExercise?.id as string,
                  },
                })
              }}
            >
              Analyst
            </Button>
          </ButtonGroup>
        </DialogBody>
        <DialogFooter>
          <Button
            onClick={() => setSelectedExercise(null)}
            fill
            intent='warning'
          >
            Close
          </Button>
        </DialogFooter>
      </Dialog>
    </Container>
  )
}

export default Index
