import { useHost } from '@inject/graphql/connection/host'
import { sessionid } from '@inject/graphql/connection/sessionid'
import { logoutUrl } from '@inject/shared/config'
import { clearNotify } from '@inject/shared/notification/engine'
import authenticatedFetch from '@inject/shared/utils/authenticatedFetch'

const useHandleLogout = () => {
  const host = useHost()
  return async () => {
    await authenticatedFetch(logoutUrl(host))
    localStorage.clear()
    sessionStorage.clear()
    indexedDB.deleteDatabase('graphcache-v3')
    clearNotify()
    sessionid('')
    window.dispatchEvent(new CustomEvent('killWs'))
  }
}

export default useHandleLogout
