import Tags from '@/components/Tags'
import { CardList, Colors, Section } from '@blueprintjs/core'
import { Cross, Tick } from '@blueprintjs/icons'
import type { TeamLearningActivity } from '@inject/graphql/fragment-types'
import type { FC } from 'react'
import MilestoneIndicator from '../InstructorMilestones/MilestoneIndicator'
import { reached, subtitle, title } from './classes'

interface LearningActivityProps {
  activity: TeamLearningActivity
  teamId: string
}

const LearningActivity: FC<LearningActivityProps> = ({ activity, teamId }) => (
  <Section
    compact
    title={<div className={title}>{activity.activity.name}</div>}
    subtitle={
      <div className={subtitle}>
        {activity.activity.description && (
          <div>{activity.activity.description}</div>
        )}
        {activity.activity.tags && <Tags tags={activity.activity.tags} />}
      </div>
    }
    className={activity.reached ? reached : undefined}
    rightElement={
      activity.reached ? (
        <Tick color={Colors.GREEN3} />
      ) : (
        <Cross color={Colors.RED3} />
      )
    }
  >
    <CardList bordered={false} compact>
      {activity.milestoneStates.map(milestoneState => (
        <MilestoneIndicator
          key={milestoneState.id}
          milestone={milestoneState}
          teamId={teamId}
        />
      ))}
    </CardList>
  </Section>
)

export default LearningActivity
