import { useTypedQuery } from '@inject/graphql/graphql'
import { GetExercise } from '@inject/graphql/queries'
import { useMemo } from 'react'

const useGetSelectedTeams = (exerciseId: string) => {
  const [{ data }] = useTypedQuery({
    query: GetExercise,
    variables: {
      exerciseId: exerciseId,
    },
  })
  const selectedTeamStates = useMemo(
    () => (data?.exerciseId.teams || []).filter(team => team.subscribed),
    [data?.exerciseId.teams]
  )

  return selectedTeamStates
}

export default useGetSelectedTeams
