import { useNavigate } from '@/router'
import { Button } from '@blueprintjs/core'
import type { FC } from 'react'

interface InstructorTeamSelectorProps {
  hideLabel?: boolean
  exerciseId?: string
}

const InstructorTeamSelector: FC<InstructorTeamSelectorProps> = ({
  hideLabel,
  exerciseId,
}) => {
  const nav = useNavigate()
  return (
    <Button
      icon='team'
      alignText='left'
      fill
      minimal
      disabled={!exerciseId}
      text={!hideLabel && 'Select teams'}
      title='Reselect set team pairing'
      onClick={() => {
        if (
          exerciseId &&
          window.confirm(
            'Are you sure you want to switch your teams? This will force re-fetching of data and induce brief performance issues'
          )
        ) {
          nav('/instructor/:exerciseId/select', {
            params: {
              exerciseId,
            },
          })
        }
      }}
    />
  )
}

export default InstructorTeamSelector
