import type { FC } from 'react'
import TeamButton from './TeamButton'
import useGetSelectedTeams from './useGetSelectedTeams'

const TeamListVertical: FC<{
  hideLabel?: boolean
  exerciseId: string
}> = ({ hideLabel, exerciseId }) => {
  const selectedTeamStates = useGetSelectedTeams(exerciseId)

  return (
    <div className='teamButtons'>
      {selectedTeamStates.map(teamState => (
        <TeamButton
          key={teamState.id}
          hideLabel={hideLabel}
          teamState={teamState}
        />
      ))}
    </div>
  )
}

export default TeamListVertical
