import type { Intent } from '@blueprintjs/core'
import { Tag } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { TeamQuestionnaireState } from '@inject/graphql/fragment-types'
import { useMemo, type FC } from 'react'

export const tag = css`
  /* prevent stretching */
  align-self: center;
`

interface StatusProps {
  teamStateStatus: TeamQuestionnaireState['status']
  canBeReviewed: boolean
}

const Status: FC<StatusProps> = ({ teamStateStatus, canBeReviewed }) => {
  const label = useMemo(() => {
    switch (teamStateStatus) {
      case 'UNSENT':
        return 'not sent'
      case 'SENT':
        // TODO: add timestamp
        return 'not answered'
      case 'ANSWERED':
        // TODO: add timestamp
        return canBeReviewed ? 'not reviewed' : 'answered'
      case 'REVIEWED':
        return 'reviewed'
      default:
        throw new Error(`Unsupported status: ${teamStateStatus}`)
    }
  }, [canBeReviewed, teamStateStatus])
  const intent: Intent = useMemo(() => {
    switch (teamStateStatus) {
      case 'UNSENT':
        return 'none'
      case 'SENT':
        return 'danger'
      case 'ANSWERED':
        return canBeReviewed ? 'warning' : 'success'
      case 'REVIEWED':
        return 'success'
      default:
        throw new Error(`Unsupported status: ${teamStateStatus}`)
    }
  }, [canBeReviewed, teamStateStatus])

  return (
    <Tag minimal round className={tag} intent={intent}>
      {label}
    </Tag>
  )
}

export default Status
