import { CardList } from '@blueprintjs/core'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetTeamMilestones } from '@inject/graphql/queries'
import notEmpty from '@inject/shared/utils/notEmpty'
import { type FC } from 'react'
import MilestoneIndicator from './MilestoneIndicator'

interface InstructorMilestonesProps {
  teamId: string
  reached: boolean
}

const InstructorMilestones: FC<InstructorMilestonesProps> = ({
  teamId,
  reached,
}) => {
  const [{ data }] = useTypedQuery({
    query: GetTeamMilestones,
    variables: { teamId },
  })

  const milestones = (data?.teamMilestones || [])
    .filter(notEmpty)
    .filter(
      milestone =>
        (reached && milestone.reached) || (!reached && !milestone.reached)
    )

  return (
    <CardList bordered={false} compact>
      {milestones.map(milestone => (
        <MilestoneIndicator
          milestone={milestone}
          key={milestone.milestone.id}
          teamId={teamId}
        />
      ))}
    </CardList>
  )
}

export default InstructorMilestones
