import type { ExtendedEmail } from '../typing'

const getForwardedMessage = (email: ExtendedEmail) => `\
**From:** ${email.sender.address}
**To:** ${email.to}
**Date:** ${new Date(email.timestamp).toUTCString()}

${email.content.raw}`

export const getForwardContent = (email: ExtendedEmail) => `

---
### Forwarded message:

${getForwardedMessage(email)}

---`

export const getForwardAllContent = (emails: ExtendedEmail[]) => `

---
## Forwarded conversation:
${emails
  .map(
    email => `
### Message #${emails.length - emails.indexOf(email)}:

${getForwardedMessage(email)}`
  )
  .join('\n')}

---`
