import { EmailSelection } from '@/analyst/utilities'
import { Card, CardList } from '@blueprintjs/core'
import type { EmailThread } from '@inject/graphql/fragment-types'
import { type FC } from 'react'
import ThreadLogCard from './ThreadLogCard'
import type { ExtendedEmaiLThread } from './typing'

interface ThreadLogCardsProps {
  teamId: string
  emailThreads: ExtendedEmaiLThread[]
  noEmailString: string
  selectedEmailThreadId?: string
  onClick: (emailThread: EmailThread) => void
  inAnalyst?: boolean
}

export const selectionStringify = (e: EmailSelection) => {
  switch (e) {
    case EmailSelection.ARCHIVED:
      return noEmailArchived
    case EmailSelection.RECEIVED:
      return noEmailReceived
    case EmailSelection.SENT:
      return noEmailSent
    default:
      return ''
  }
}
export const noEmailReceived = 'No emails received'
export const noEmailSent = 'No emails sent'
export const noEmailArchived = 'No emails archived'

const ThreadLogCards: FC<ThreadLogCardsProps> = ({
  teamId,
  emailThreads,
  noEmailString,
  selectedEmailThreadId,
  onClick,
  inAnalyst = false,
}) => (
  <CardList bordered={false}>
    {emailThreads.length > 0 ? (
      emailThreads.map(emailThread => (
        <ThreadLogCard
          key={emailThread.id}
          emailThread={emailThread}
          lastEmail={emailThread.lastEmail}
          teamId={teamId}
          isSelected={emailThread.id === selectedEmailThreadId}
          onClick={() => onClick(emailThread)}
          inAnalyst={inAnalyst}
        />
      ))
    ) : (
      <Card>{noEmailString}</Card>
    )}
  </CardList>
)

export default ThreadLogCards
