import Description from '@/components/Description'
import { css } from '@emotion/css'
import type { EmailParticipant } from '@inject/graphql/fragment-types'
import type { FC } from 'react'

const wrapper = css`
  display: flex;
  flex-wrap: wrap;
  column-gap: 0.25rem;
  align-items: end;
`

const instructorAddressLabel = css`
  display: flex;
`

interface SubtitleProps {
  showDescription: boolean
  participants: EmailParticipant[]
}

const Subtitle: FC<SubtitleProps> = ({ showDescription, participants }) =>
  showDescription ? (
    <div className={wrapper}>
      {participants.map((participant, index) => (
        <div key={participant.id} className={instructorAddressLabel}>
          <Description
            description={participant.definitionAddress?.description}
            hideDescription={!participant.definitionAddress}
          >
            {participant.address}
          </Description>
          {index < participants.length - 1 && ', '}
        </div>
      ))}
    </div>
  ) : (
    participants.map(participant => participant.address).join(', ')
  )

export default Subtitle
