import { useTypedQuery } from '@inject/graphql/graphql'
import { GetTeamEmailParticipant } from '@inject/graphql/queries'
import type { FC } from 'react'
import EmailFormOverlay from '.'

interface TraineeEmailFormOverlayProps {
  teamId: string
  exerciseId: string
}

const TraineeEmailFormOverlay: FC<TraineeEmailFormOverlayProps> = ({
  teamId,
  exerciseId,
}) => {
  const [{ data, fetching: loading, error }] = useTypedQuery({
    query: GetTeamEmailParticipant,
    variables: {
      teamId,
    },
    pause: !teamId,
  })

  return (
    <EmailFormOverlay
      teamId={teamId}
      emailForm='trainee'
      exerciseId={exerciseId}
      teamAddress={data?.teamEmailParticipant?.address || ''}
      loading={loading || !data?.teamEmailParticipant?.address}
      error={error}
    />
  )
}

export default TraineeEmailFormOverlay
