import type { EditorConfig } from '@/editor/useEditorStorage'
import type { ConfigYaml } from '../types'

export const parseConfig = (
  config: ConfigYaml
): Pick<
  EditorConfig,
  | 'exerciseDuration'
  | 'emailBetweenTeams'
  | 'customEmailSuffix'
  | 'showExerciseTime'
> => ({
  exerciseDuration: config.exercise_duration,
  emailBetweenTeams: config.email_between_teams,
  customEmailSuffix: config.custom_email_suffix,
  showExerciseTime: config.show_exercise_time,
})
