import type { EditorConfig } from '@/editor/useEditorStorage'
import type { ChannelYaml } from '../types'

export const parseChannels = (
  channels: ChannelYaml[]
): Pick<
  EditorConfig,
  'infoChannelName' | 'emailChannelName' | 'toolChannelName' | 'formChannelName'
> => ({
  infoChannelName: channels.find(channel => channel.type === 'info')?.name,
  emailChannelName: channels.find(channel => channel.type === 'email')?.name,
  toolChannelName: channels.find(channel => channel.type === 'tool')?.name,
  formChannelName: channels.find(channel => channel.type === 'form')?.name,
})
