import { addMarkdownContent } from '@/editor/indexeddb/operations'
import type {
  ContentFile,
  MilestoneName,
  Overlay,
} from '@/editor/indexeddb/types'
import { getMilestoneNameForOutput } from '@/editor/utils'
import type { OptionProps } from '@blueprintjs/core'
import { isEmpty, pickBy } from 'lodash'

export const generateContent = async (
  contentName: string,
  content?: string,
  file?: ContentFile
) => {
  const contentFileName = `${contentName}.md`
  // eslint-disable-next-line @typescript-eslint/no-unused-expressions
  content && (await addMarkdownContent({ content, fileName: contentFileName }))
  const generatedContent = pickBy({
    content_path: contentFileName,
    fileName: file?.name,
  })

  return isEmpty(generatedContent) ? undefined : generatedContent
}

export const generateControl = (
  activateMilestone?: MilestoneName,
  milestoneCondition?: OptionProps[]
) => {
  const generatedControl = pickBy({
    activate_milestone: activateMilestone
      ? getMilestoneNameForOutput(activateMilestone)
      : '',
    milestone_condition: milestoneCondition
      ?.map(block => block.label)
      .join(' '),
  })

  return isEmpty(generatedControl) ? undefined : generatedControl
}

export const generateOverlay = (overlay?: Overlay) => {
  const generatedOverlay = pickBy({ duration: overlay?.duration })

  return isEmpty(generatedOverlay) ? undefined : generatedOverlay
}
