import { getLearningObjectivesWithActivities } from '@/editor/indexeddb/joins'
import type {
  JoinedLearningObjective,
  LearningActivityInfo,
} from '@/editor/indexeddb/types'

const generateActivities = (activities: LearningActivityInfo[]) =>
  activities.map((activity: LearningActivityInfo) => ({
    name: activity.name,
  }))

export const generateObjectives = async () => {
  const objectives = await getLearningObjectivesWithActivities()

  return objectives.map((objective: JoinedLearningObjective) => ({
    name: objective.name,
    activities: generateActivities(objective.activities),
  }))
}
