import { getUsedMilestones } from '@/editor/indexeddb/joins'
import type { MilestoneName } from '@/editor/indexeddb/types'
import { MilestoneEventType } from '@/editor/indexeddb/types'
import type { EditorConfig } from '@/editor/useEditorStorage'
import { getMilestoneNameForOutput } from '@/editor/utils'
import { pickBy } from 'lodash'

export const generateMilestones = async (config: EditorConfig) => {
  const milestones = await getUsedMilestones()

  return milestones.map((milestone: MilestoneName) =>
    pickBy({
      name: getMilestoneNameForOutput(milestone),
      activity:
        milestone.type === MilestoneEventType.LEARNING_ACTIVITY
          ? milestone.name
          : '',
      final: milestone.id === config.finalMilestone,
    })
  )
}
