import type { EditorConfig } from '@/editor/useEditorStorage'
import { pickBy } from 'lodash'
import { db } from '../../indexeddb/db'

export const generateConfig = async (config: EditorConfig) => {
  const emailAddressesCount = await db.emailAddresses.count()

  const generatedConfig = {
    exercise_duration: config.exerciseDuration,
    email_between_teams: emailAddressesCount ? config.emailBetweenTeams : null,
    custom_email_suffix:
      emailAddressesCount && config.emailBetweenTeams
        ? config.customEmailSuffix
        : null,
    show_exercise_time: config.showExerciseTime,
    version: '0.13.0',
  }

  return pickBy(generatedConfig)
}
