import { useLocalStorageState } from 'ahooks'
import type { Project } from './gitlabAccess'

export interface GitlabConfig {
  gitlabHost?: string
  groupPath?: string
  groupId?: number
  token?: string
  project?: Project
  branchFrom?: string
}

const useGitlabStorage = () =>
  useLocalStorageState<GitlabConfig>('inject-gitlab-config', {
    defaultValue: {
      gitlabHost: 'https://gitlab.fi.muni.cz',
      groupPath: 'inject/definitions',
    },
    listenStorageChange: true,
  })

export default useGitlabStorage
