import { useLocalStorageState } from 'ahooks'

export interface EditorConfig {
  introChecked?: boolean[]
  conclusionChecked?: boolean[]
  name?: string
  description?: string
  trainee?: string
  exerciseDuration?: number
  showExerciseTime?: boolean
  finalMilestone?: number
  emailBetweenTeams?: boolean
  customEmailSuffix?: string
  infoChannelName?: string
  toolChannelName?: string
  emailChannelName?: string
  formChannelName?: string
  fileNames?: string[]
}

const useEditorStorage = () =>
  useLocalStorageState<EditorConfig>('editor-config', {
    defaultValue: {},
    listenStorageChange: true,
  })

export default useEditorStorage
