import { Label } from '@blueprintjs/core'
import type { CSSProperties, ReactNode } from 'react'
import { memo, type FC } from 'react'
import type { ExtendedLabel } from '../../types'
import TooltipLabelContent from '../TooltipLabelContent'

interface TooltipLabelProps {
  label: ExtendedLabel
  children: ReactNode
  style?: CSSProperties
}

const TooltipLabel: FC<TooltipLabelProps> = ({ label, children, style }) => (
  <Label style={style}>
    <div style={{ display: 'flex', alignItems: 'center' }}>
      <TooltipLabelContent label={label} style={{ marginBottom: '0.3rem' }} />
    </div>
    {children}
  </Label>
)

export default memo(TooltipLabel)
