import type { CheckboxProps } from '@blueprintjs/core'
import { Checkbox } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import type { ExtendedLabel } from '../../types'
import TooltipLabelContent from '../TooltipLabelContent'

interface TooltipCheckboxProps {
  label: ExtendedLabel
  checkboxProps: CheckboxProps
}

const TooltipCheckbox: FC<TooltipCheckboxProps> = ({
  label,
  checkboxProps,
}) => (
  <Checkbox {...checkboxProps}>
    <TooltipLabelContent label={label} />
  </Checkbox>
)

export default memo(TooltipCheckbox)
