import {
  InputGroup,
  NumericInput,
  Tab,
  Tabs,
  TabsExpander,
  TextArea,
} from '@blueprintjs/core'
import { memo, type FC } from 'react'
import ExpressionBuilder from '../ExpressionBuilder'
import FileSelector from '../FileSelector'
import ToolSelector from '../ToolSelector'
import TooltipCheckbox from '../Tooltips/TooltipCheckbox'
import TooltipLabel from '../Tooltips/TooltipLabel'
import {
  TOOL_RESPONSE_CONNECTIONS_FORM,
  TOOL_RESPONSE_FORM,
} from '../assets/pageContent/tools'

interface ToolResponseFormProps {
  parameter: string
  onParameterChange: (value: string) => void
  content: string
  onContentChange: (value: string) => void
  isRegex: boolean
  onIsRegexChange: (value: boolean) => void
  toolId: number
  onToolIdChange: (value: number) => void
  fileId: number
  onFileIdChange: (value: number) => void
  time: number
  onTimeChange: (value: number) => void
  milestoneCondition?: number[]
  onMilestoneConditionChange: (value: number[]) => void
}

const ToolResponseForm: FC<ToolResponseFormProps> = ({
  parameter,
  onParameterChange,
  content,
  onContentChange,
  isRegex,
  onIsRegexChange,
  toolId,
  onToolIdChange,
  fileId,
  onFileIdChange,
  time,
  onTimeChange,
  milestoneCondition,
  onMilestoneConditionChange,
}) => (
  <Tabs>
    <Tab
      id='parameters'
      title='Parameters'
      panel={
        <div>
          <ToolSelector
            label={TOOL_RESPONSE_FORM.tool}
            toolId={toolId}
            onChange={id => onToolIdChange(id)}
          />
          <TooltipLabel label={TOOL_RESPONSE_FORM.parameter}>
            <InputGroup
              placeholder='Input text'
              value={parameter}
              onChange={e => onParameterChange(e.target.value)}
            />
          </TooltipLabel>
          <TooltipCheckbox
            label={TOOL_RESPONSE_FORM.isRegex}
            checkboxProps={{
              checked: isRegex,
              onChange: () => onIsRegexChange(!isRegex),
            }}
          />
          <TooltipLabel label={TOOL_RESPONSE_FORM.response}>
            <TextArea
              value={content}
              style={{
                width: '100%',
                height: '10rem',
                resize: 'none',
                overflowY: 'auto',
              }}
              placeholder='Input text'
              onChange={e => onContentChange(e.target.value)}
            />
          </TooltipLabel>
          <FileSelector
            label={TOOL_RESPONSE_FORM.file}
            fileId={fileId}
            onChange={id => onFileIdChange(id)}
          />
        </div>
      }
    />
    <Tab
      id='connections'
      title='Connections'
      panel={
        <div>
          <TooltipLabel label={TOOL_RESPONSE_CONNECTIONS_FORM.time}>
            <NumericInput
              placeholder='Input number'
              min={0}
              value={time}
              onValueChange={(value: number) => onTimeChange(value)}
            />
          </TooltipLabel>
          <ExpressionBuilder
            label={TOOL_RESPONSE_CONNECTIONS_FORM.condition}
            initExpression={milestoneCondition}
            onExpressionChange={expression =>
              onMilestoneConditionChange(expression)
            }
          />
        </div>
      }
    />
    <TabsExpander />
  </Tabs>
)

export default memo(ToolResponseForm)
