import type { Path } from '@/router'
import { useNavigate } from '@/router'
import { Button, ButtonGroup } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import { GENERIC_CONTENT } from '../assets/generalContent'

interface SaveButtonGroupProps {
  isValid: boolean
  handleUpdate: () => void
  prevPath: Path
}

const SaveButtonGroup: FC<SaveButtonGroupProps> = ({
  isValid,
  handleUpdate,
  prevPath,
}) => {
  const nav = useNavigate()

  return (
    <ButtonGroup>
      <Button
        disabled={!isValid}
        onClick={() => {
          handleUpdate()
          nav(prevPath)
        }}
        intent='primary'
        icon='arrow-left'
        text={GENERIC_CONTENT.buttons.saveAndExit}
        style={{ marginRight: '0.5rem' }}
      />
      <Button
        disabled={!isValid}
        onClick={() => handleUpdate()}
        icon='edit'
        text={GENERIC_CONTENT.buttons.save}
      />
    </ButtonGroup>
  )
}

export default memo(SaveButtonGroup)
