import type { IconName } from '@blueprintjs/core'
import { Card, Icon, Tooltip } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC } from 'react'
import { memo } from 'react'

const overviewCard = css`
  display: flex;
  justify-content: space-between;
`

interface OverviewCardProps {
  name: string
  icon?: IconName
  onClick: () => void
  isSpecified?: boolean
  tooltipContent: string
}

const OverviewCard: FC<OverviewCardProps> = ({
  name,
  icon,
  onClick,
  isSpecified,
  tooltipContent,
}) => (
  <Card interactive onClick={onClick} className={overviewCard}>
    <span>
      {icon && <Icon icon={icon} style={{ marginRight: '1rem' }} />}
      {name}
    </span>
    {!isSpecified && (
      <Tooltip content={tooltipContent}>
        <Icon icon='high-priority' intent='warning' size={20} />
      </Tooltip>
    )}
  </Card>
)

export default memo(OverviewCard)
