import { useLiveQuery } from 'dexie-react-hooks'
import { memo } from 'react'
import {
  areActivitiesSpecified,
  areInjectsSpecified,
  doInjectsHaveCorrectConditions,
  doLearningActivitiesHaveCorrectConditions,
  doToolResponsesHaveCorrectConditions,
  doToolsHaveResponses,
} from '../indexeddb/operations'
import { NavigationLinkNames } from '../types'
import useEditorAccessStorage from '../useEditorAccessStorage'
import NavbarButton from './NavbarButton'

const Navbar = () => {
  const [access] = useEditorAccessStorage()

  const activitiesSpecified = useLiveQuery(
    () => areActivitiesSpecified(),
    [],
    false
  )
  const activitiesHaveCorrectConditions = useLiveQuery(
    () => doLearningActivitiesHaveCorrectConditions(),
    [],
    false
  )

  const injectsSpecified = useLiveQuery(() => areInjectsSpecified(), [], false)
  const injectsHaveCorrectConditions = useLiveQuery(
    () => doInjectsHaveCorrectConditions(),
    [],
    false
  )

  const toolsHaveResponses = useLiveQuery(
    () => doToolsHaveResponses(),
    [],
    false
  )
  const toolsHaveCorrectConditions = useLiveQuery(
    () => doToolResponsesHaveCorrectConditions(),
    [],
    false
  )

  return (
    <div style={{ display: 'flex', flexDirection: 'column' }}>
      <NavbarButton
        path='/editor/create/introduction'
        linkKey={NavigationLinkNames.INTRODUCTION}
        visible
        filled={access?.introductionFilled}
      />
      <NavbarButton
        path='/editor/create/exercise-information'
        linkKey={NavigationLinkNames.EXERCISE_INFORMATION}
        visible={access?.introductionFilled}
        filled={access?.exerciseInformationFilled}
      />
      <NavbarButton
        path='/editor/create/learning-objectives'
        linkKey={NavigationLinkNames.LEARNING_OBJECTIVES}
        visible={access?.exerciseInformationFilled}
        filled={access?.objectivesFilled}
      />
      <NavbarButton
        path='/editor/create/injects'
        linkKey={NavigationLinkNames.INJECTS}
        visible={access?.objectivesFilled}
        filled={access?.injectsFilled}
      />
      <NavbarButton
        path='/editor/create/activity-specification'
        linkKey={NavigationLinkNames.ACTIVITY_SPECIFICATION_OVERVIEW}
        visible={access?.injectsFilled}
        filled={activitiesSpecified && activitiesHaveCorrectConditions}
      />
      <NavbarButton
        path='/editor/create/inject-specification'
        linkKey={NavigationLinkNames.INJECT_SPECIFICATION_OVERVIEW}
        visible={access?.injectsFilled}
        filled={injectsSpecified && injectsHaveCorrectConditions}
      />
      <NavbarButton
        path='/editor/create/other'
        linkKey={NavigationLinkNames.OTHER}
        visible={access?.injectsFilled}
        filled={toolsHaveResponses && toolsHaveCorrectConditions}
      />
      <NavbarButton
        path='/editor/create/final-information'
        linkKey={NavigationLinkNames.FINAL_INFORMATION}
        visible={access?.specificationsFilled}
        filled={access?.finalInformationFilled}
      />
      <NavbarButton
        path='/editor/create/conclusion'
        linkKey={NavigationLinkNames.CONCLUSION}
        visible={access?.finalInformationFilled}
        filled={access?.conclusionFilled}
      />
      <NavbarButton
        path='/editor/create/save'
        linkKey={NavigationLinkNames.DOWNLOAD}
        visible={access?.conclusionFilled}
        filled
      />
    </div>
  )
}

export default memo(Navbar)
