import LearningActivityItem from '@/editor/LearningActivities/LearningActivity'
import { db } from '@/editor/indexeddb/db'
import type { LearningActivityInfo } from '@/editor/indexeddb/types'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import type { FC } from 'react'
import { memo } from 'react'

interface LearningActivitiesProps {
  learningObjectiveId: number
}

const LearningActivities: FC<LearningActivitiesProps> = ({
  learningObjectiveId,
}) => {
  const learningActivities = useLiveQuery(
    () => db.learningActivities.where({ learningObjectiveId }).toArray(),
    [learningObjectiveId],
    []
  )

  return (
    <CardList>
      {learningActivities?.map((activity: LearningActivityInfo) => (
        <LearningActivityItem key={activity.id} learningActivity={activity} />
      ))}
    </CardList>
  )
}

export default memo(LearningActivities)
