import TooltipLabel from '@/editor/Tooltips/TooltipLabel'
import { QUESTIONNAIRE_FORM } from '@/editor/assets/pageContent/injectSpecification'
import { db } from '@/editor/indexeddb/db'
import type { QuestionnaireQuestion } from '@/editor/indexeddb/types'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import type { FC } from 'react'
import { memo } from 'react'
import QuestionnaireQuestionItem from './QuestionnaireQuestion'

interface QuestionnaireQuestionsProps {
  questionnaireId: number
}

const QuestionnaireQuestions: FC<QuestionnaireQuestionsProps> = ({
  questionnaireId,
}) => {
  const questionnaireQuestions = useLiveQuery(
    () => db.questionnaireQuestions.where({ questionnaireId }).toArray(),
    [questionnaireId],
    []
  )

  return (
    <TooltipLabel label={QUESTIONNAIRE_FORM.questions}>
      <CardList style={{ marginTop: '1rem' }}>
        {questionnaireQuestions?.map((question: QuestionnaireQuestion) => (
          <QuestionnaireQuestionItem
            key={question.id}
            questionnaireQuestion={question}
          />
        ))}
      </CardList>
    </TooltipLabel>
  )
}

export default memo(QuestionnaireQuestions)
