import { InputGroup, Section, SectionCard } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import TooltipLabel from '../Tooltips/TooltipLabel'
import { INFORMATION_CHANNEL_FORM } from '../assets/pageContent/finalInformation'

interface InfoChannelFormProps {
  infoChannelName: string
  onInfoChannelNameChange: (infoChannelName: string) => void
}

const InfoChannelForm: FC<InfoChannelFormProps> = ({
  infoChannelName,
  onInfoChannelNameChange,
}) => (
  <Section title='Information' style={{ marginBottom: '1rem' }}>
    <SectionCard>
      <TooltipLabel label={INFORMATION_CHANNEL_FORM.name}>
        <InputGroup
          placeholder='Input text'
          value={infoChannelName}
          onChange={e => onInfoChannelNameChange(e.target.value)}
        />
      </TooltipLabel>
    </SectionCard>
  </Section>
)

export default memo(InfoChannelForm)
