import { NumericInput } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import TooltipCheckbox from '../Tooltips/TooltipCheckbox'
import TooltipLabel from '../Tooltips/TooltipLabel'
import { EXERCISE_DURATION_FORM } from '../assets/pageContent/finalInformation'

interface ExerciseDurationFormProps {
  exerciseDuration: number
  onExerciseDurationChange: (exerciseDuration: number) => void
  showExerciseTime: boolean
  onShowExerciseTimeChange: (showExerciseTime: boolean) => void
}

const ExerciseDurationForm: FC<ExerciseDurationFormProps> = ({
  exerciseDuration,
  onExerciseDurationChange,
  showExerciseTime,
  onShowExerciseTimeChange,
}) => (
  <div>
    <TooltipLabel label={EXERCISE_DURATION_FORM.exerciseDuration}>
      <NumericInput
        placeholder='Input number'
        value={exerciseDuration}
        onValueChange={(value: number) => onExerciseDurationChange(value)}
      />
    </TooltipLabel>
    <TooltipCheckbox
      label={EXERCISE_DURATION_FORM.showTime}
      checkboxProps={{
        checked: showExerciseTime,
        onChange: () => onShowExerciseTimeChange(!showExerciseTime),
      }}
    />
  </div>
)

export default memo(ExerciseDurationForm)
