import { InputGroup, Section, SectionCard } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import TooltipCheckbox from '../Tooltips/TooltipCheckbox'
import TooltipLabel from '../Tooltips/TooltipLabel'
import { EMAIL_CHANNEL_FORM } from '../assets/pageContent/finalInformation'

interface EmailChannelFormProps {
  emailChannelName: string
  onEmailChannelNameChange: (emailChannelName: string) => void
  emailBetweenTeams: boolean
  onEmailBetweenTeamsChange: (emailBetweenTeams: boolean) => void
  customEmailSuffix: string
  onCustomEmailSuffixChange: (customEmailSuffix: string) => void
}

const EmailChannelForm: FC<EmailChannelFormProps> = ({
  emailChannelName,
  onEmailChannelNameChange,
  emailBetweenTeams,
  onEmailBetweenTeamsChange,
  customEmailSuffix,
  onCustomEmailSuffixChange,
}) => (
  <Section title='Email' style={{ marginBottom: '1rem' }}>
    <SectionCard>
      <TooltipLabel label={EMAIL_CHANNEL_FORM.name}>
        <InputGroup
          placeholder='Input text'
          value={emailChannelName}
          onChange={e => onEmailChannelNameChange(e.target.value)}
        />
      </TooltipLabel>
      <TooltipCheckbox
        label={EMAIL_CHANNEL_FORM.emailsBetweenTeams}
        checkboxProps={{
          checked: emailBetweenTeams,
          onChange: () => onEmailBetweenTeamsChange(!emailBetweenTeams),
        }}
      />
      {emailBetweenTeams && (
        <TooltipLabel label={EMAIL_CHANNEL_FORM.suffix}>
          <InputGroup
            placeholder='Input text'
            value={customEmailSuffix}
            onChange={e => onCustomEmailSuffixChange(e.target.value)}
          />
        </TooltipLabel>
      )}
    </SectionCard>
  </Section>
)

export default memo(EmailChannelForm)
