import { useLiveQuery } from 'dexie-react-hooks'
import { useMemo } from 'react'
import { db } from '../indexeddb/db'
import { validateExpression } from '../utils'

const useValidateExpression = (expression?: number[]) => {
  const milestones = useLiveQuery(() => db.milestones.toArray(), [], [])

  const { isValid, error } = useMemo(
    () => validateExpression(expression || [], milestones),
    [expression, milestones]
  )

  return { isValid, error }
}

export default useValidateExpression
