import { db } from '@/editor/indexeddb/db'
import type { EmailTemplate } from '@/editor/indexeddb/types'
import { CardList } from '@blueprintjs/core'
import { useLiveQuery } from 'dexie-react-hooks'
import type { FC } from 'react'
import { memo } from 'react'
import EmailTemplateItem from './EmailTemplate'

interface EmailTemplatesProps {
  emailAddressId: number
}

const EmailTemplates: FC<EmailTemplatesProps> = ({ emailAddressId }) => {
  const emailTemplates = useLiveQuery(
    () =>
      db.emailTemplates
        .where({ emailAddressId: Number(emailAddressId) })
        .toArray(),
    [emailAddressId],
    []
  )

  return (
    <CardList>
      {emailTemplates?.map((emailTemplate: EmailTemplate) => (
        <EmailTemplateItem
          key={emailTemplate.id}
          emailTemplate={emailTemplate}
        />
      ))}
    </CardList>
  )
}

export default memo(EmailTemplates)
