import { InputGroup, TextArea } from '@blueprintjs/core'
import { memo, type FC } from 'react'
import EmailAddressSelector from '../EmailAddressSelector'
import FileSelector from '../FileSelector'
import TooltipLabel from '../Tooltips/TooltipLabel'
import { EMAIL_TEMPLATE_FORM } from '../assets/pageContent/emails'

interface EmailTemplateFormProps {
  context: string
  onContextChange: (value: string) => void
  content: string
  onContentChange: (value: string) => void
  emailAddressId: number
  onEmailAddressIdChange: (value: number) => void
  fileId: number
  onFileIdChange: (value: number) => void
}

const EmailTemplateForm: FC<EmailTemplateFormProps> = ({
  context,
  onContextChange,
  content,
  onContentChange,
  emailAddressId,
  onEmailAddressIdChange,
  fileId,
  onFileIdChange,
}) => (
  <div>
    <EmailAddressSelector
      label={EMAIL_TEMPLATE_FORM.address}
      emailAddressId={emailAddressId}
      onChange={id => onEmailAddressIdChange(id)}
    />
    <TooltipLabel label={EMAIL_TEMPLATE_FORM.context}>
      <InputGroup
        placeholder='Input text'
        value={context}
        onChange={e => onContextChange(e.target.value)}
      />
    </TooltipLabel>
    <TooltipLabel label={EMAIL_TEMPLATE_FORM.content}>
      <TextArea
        value={content}
        style={{
          width: '100%',
          height: '10rem',
          resize: 'none',
          overflowY: 'auto',
        }}
        placeholder='Input text'
        onChange={e => onContentChange(e.target.value)}
      />
    </TooltipLabel>
    <FileSelector
      label={EMAIL_TEMPLATE_FORM.file}
      fileId={fileId}
      onChange={id => onFileIdChange(id)}
    />
  </div>
)

export default memo(EmailTemplateForm)
