import { HTMLSelect } from '@blueprintjs/core'
import type { FC } from 'react'
import { memo } from 'react'

interface BranchSelectorProps {
  branches: string[]
  selectedBranch?: string
  onSelectedBranchChange: (value: string) => void
}

const BranchSelector: FC<BranchSelectorProps> = ({
  branches,
  selectedBranch,
  onSelectedBranchChange,
}) => (
  <HTMLSelect
    options={branches}
    value={selectedBranch}
    onChange={event => onSelectedBranchChange(event.currentTarget.value)}
  />
)

export default memo(BranchSelector)
