import { css } from '@emotion/css'
import StyledTag from '@inject/shared/components/StyledTag'
import type { FC } from 'react'

const wrapper = css`
  display: flex;
  gap: 0.5rem;
  flex-wrap: wrap;
`

type TagsProps =
  | {
      tags: string
      tagsArray?: never
    }
  | {
      tags?: never
      tagsArray: string[]
    }

const Tags: FC<TagsProps> = ({ tags, tagsArray }) => {
  const processedTags = tagsArray || tags.split(', ')

  return (
    <div className={wrapper}>
      {processedTags.map(tag => (
        <StyledTag key={tag} content={tag} />
      ))}
    </div>
  )
}

export default Tags
