import type { CSSProperties, ReactNode } from 'react'

export interface Column<T> {
  id: string
  name: string
  display?: boolean
  style?: CSSProperties
  className?: string
  renderValue: (value: T) => ReactNode
  valueStyle?: (value: T) => CSSProperties | undefined
  valueClassName?: (value: T) => string
}

export interface Row<T> {
  id: string
  value: T
  style?: CSSProperties
  className?: string
  onClick?: () => void
}
