import { css, cx } from '@emotion/css'
import type { Team } from '@inject/graphql/fragment-types'
import { useLoopStatus } from '@inject/graphql/utils/useExerciseLoopStatusSubscription'
import type { FC } from 'react'
import TeamLabel from '../TeamLabel'
import HealthCheck from './HealthCheck'
import TimeLeft from './TimeLeft'

const wrapper = css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
  align-items: center;
`

const header = css`
  padding: 0.25rem 0.5rem;
  display: flex;
  gap: 0.5rem;
  justify-content: center;
  align-items: center;
`

const vertical = css`
  flex-direction: column;
`

interface StatusProps {
  small: boolean
  showTime: boolean
  team?: Team
  hideLabel?: boolean
}

const Status: FC<StatusProps> = ({ showTime, team, hideLabel }) => {
  const { running, exerciseId } = useLoopStatus()

  return (
    <div className={wrapper}>
      <div
        className={cx({
          [header]: true,
          [vertical]: hideLabel,
        })}
      >
        <HealthCheck />
        {running && showTime && <TimeLeft />}
        {!running && exerciseId && <span>Stopped</span>}
        {team && (
          <TeamLabel
            teamId={team.id}
            teamName={team.name}
            hideLabel={hideLabel}
            exerciseName={team.exercise.name}
            teamRole={team.role}
          />
        )}
      </div>
    </div>
  )
}

export default Status
