import { Spinner } from '@blueprintjs/core'
import { useLoopStatus } from '@inject/graphql/utils/useExerciseLoopStatusSubscription'

const HealthCheck = () => {
  /*
   * This is a dummy element which is used for propagating load states from `@inject/graphql` package, it's necessary that this element is mounted in needed places and that it's a singleton. It's not useless :)
   */
  const { running } = useLoopStatus()
  return (
    <Spinner
      id='counterElement'
      size={24}
      value={1}
      intent={running ? 'success' : 'danger'}
      title={`backend status: no queries ran yet`}
    />
  )
}

export default HealthCheck
