import type { CSSProperties } from 'react'

export type ValueType = string | number | boolean | Date | null

export interface Column {
  id: string
  name: string
  display?: boolean
  style: CSSProperties | undefined
  valueStyle?: CSSProperties | undefined
}

export interface Row {
  id: string
  columns: Column[]
  values: ValueType[]
  onClick?: () => void
  class?: string | undefined
}

export interface SelectingRow extends Row {
  isSelected: boolean
  onClick: () => void
}

export enum SortingFunction {
  ASC,
  DESC,
}
