import { Classes, Colors } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { breakWord } from '@inject/shared/css/textOverflow'

export const tableCell = css`
  padding: 0.5rem 1rem;
  vertical-align: text-top;
`

export const selectHeaderCell = css`
  width: calc(2rem + 16px);
`

export const checkbox = css`
  margin: 0;
  padding: 0;
`

export const sticky = css`
  z-index: 1;
  position: sticky;
  top: 0;
  background-color: ${Colors.LIGHT_GRAY5};

  .${Classes.DARK} & {
    background-color: ${Colors.DARK_GRAY4};
  }
`

export const preWrappedOnHover = css`
  &:hover {
    white-space: pre-wrap;
    ${breakWord}
  }
`

export const clickable = css`
  cursor: pointer;
`
