import { InputGroup, Label, TextArea } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FreeFormQuestionDetails } from '@inject/graphql/fragment-types'
import { breakWord } from '@inject/shared/css/textOverflow'
import type { FC } from 'react'
import RenderedContent from '../RenderedContent'
import type { QuestionProps } from './types'

const label = css`
  margin-bottom: 0.5rem !important;
`

const textArea = css`
  resize: none;
`

const FreeFormQuestion: FC<QuestionProps> = ({
  type,
  question,
  answer,
  disabled: disabledProp,
  onChange,
  inInstructor,
  teamId,
}) => {
  const details = question.details as FreeFormQuestionDetails
  // TODO: reviewing (related milestones)
  const { multiline } = details

  const disabled = disabledProp || type === 'reviewing'

  return (
    <Label className={label}>
      <RenderedContent
        className={breakWord}
        teamId={teamId}
        inInstructor={inInstructor}
        renderedContent={question.content.rendered}
      />
      {multiline ? (
        <TextArea
          readOnly={disabled}
          fill
          value={answer}
          onChange={
            onChange ? event => onChange(event.currentTarget.value) : undefined
          }
          rows={5}
          className={textArea}
        />
      ) : (
        <InputGroup
          readOnly={disabled}
          fill
          value={answer}
          onChange={
            onChange ? event => onChange(event.currentTarget.value) : undefined
          }
        />
      )}
    </Label>
  )
}

export default FreeFormQuestion
