import useHandleLogout from '@/logic/Login/useHandleLogout'
import { Button } from '@blueprintjs/core'
import usePopoverElement from '@inject/shared/popover/usePopoverElement'
import { useState, type FC } from 'react'

interface UserTitleProps {
  username: string
}

const UserTitle: FC<UserTitleProps> = ({ username }) => {
  const handleLogout = useHandleLogout()

  const [open, setOpen] = useState(false)

  const { children, getReferenceProps, setReference } = usePopoverElement({
    open,
    setOpen,
    placement: 'top',
    children: (
      <Button intent='danger' icon='log-out' onClick={handleLogout}>
        Logout
      </Button>
    ),
  })

  return (
    <>
      <Button
        ref={setReference}
        icon='user'
        active={open}
        minimal
        onClick={() => setOpen(prev => !prev)}
        {...getReferenceProps}
      >
        {username}
      </Button>
      {children}
    </>
  )
}

export default UserTitle
